package com.gilman.truguitartuner;

import android.os.Parcel;
import android.os.Parcelable;

public class TuningType implements Parcelable {
    public String humanReadableName;
    public double[] freqs;
    public String[] stringNames;
    public int iconResourceId;
    public  int colorResId;



    public TuningType(String humanReadableName, double[] freqs, String[] stringNames, int iconResourceId, int colorResId) {
        this.humanReadableName = humanReadableName;
        this.freqs = freqs;
        this.stringNames = stringNames;
        this.iconResourceId = iconResourceId;
        this.colorResId = colorResId; // <-- ADD THIS LINE
    }


    // This is important so the ListView shows the name
    @Override
    public String toString() {
        return humanReadableName;
    }


    protected TuningType(Parcel in) {
        humanReadableName = in.readString();
        freqs = in.createDoubleArray();       // Correct method for double[]
        stringNames = in.createStringArray(); // Correct method for String[]
        iconResourceId = in.readInt();
        colorResId = in.readInt();
        // Correct method for int
    }
    public static final Creator<TuningType> CREATOR = new Creator<TuningType>() {
        @Override
        public TuningType createFromParcel(Parcel in) {
            return new TuningType(in);
        }

        @Override
        public TuningType[] newArray(int size) {
            return new TuningType[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    // In TuningType.java

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(humanReadableName);
        dest.writeDoubleArray(freqs);        // Write the double array
        dest.writeStringArray(stringNames);  // Write the String array
        dest.writeInt(iconResourceId);
        dest.writeInt(colorResId);// Write the int
    }
}
