package com.gilman.truguitartuner;
// In TuningAdapter.java

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

// In TuningAdapter.java

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView; // <-- Make sure this is imported

public class TuningAdapter extends ArrayAdapter<TuningType> {

    private OnInfoClickListener infoClickListener;

    public TuningAdapter(Context context, TuningType[] tunings, OnInfoClickListener listener) {
        super(context, 0, tunings);
        this.infoClickListener = listener;
    }

    public interface OnInfoClickListener {
        void onInfoClick(TuningType tuning);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        // Get the data item for this position
        TuningType tuning = getItem(position);

        // Check if an existing view is being reused, otherwise inflate the view
        if (convertView == null) {
            convertView = LayoutInflater.from(getContext()).inflate(R.layout.list_item_tuning_2, parent, false);
        }

        // --- THIS IS THE CRITICAL PART THAT IS LIKELY MISSING OR WRONG ---

        // 1. Find the TextView and ImageView in the layout
        TextView tvName = convertView.findViewById(R.id.tuning_name);
        ImageView ivIcon = convertView.findViewById(R.id.tuning_icon);
        ImageView infoIcon = convertView.findViewById(R.id.tuning_info_icon);

        // 2. Populate the data into the template view.
        if (tuning != null) {
            tvName.setText(tuning.humanReadableName); // <-- Set the tuning name
            ivIcon.setImageResource(tuning.iconResourceId); // <-- Set the instrument icon
        }

        // 3. Set up the click listeners (your existing code is likely here)
        infoIcon.setOnClickListener(v -> {
            if (infoClickListener != null) {
                infoClickListener.onInfoClick(tuning);
            }
        });

        convertView.setOnClickListener(v -> {
            Intent intent = new Intent(getContext(), MainActivity.class);
            // Send the position integer, which is what MainActivity is expecting.
            intent.putExtra("selectedTuning", position);
            getContext().startActivity(intent);
        });
        // --- END OF CRITICAL PART ---

        // Return the completed view to render on screen
        return convertView;
    }
}