package com.gilman.truguitartuner;

// A simple class to hold the data for a guitar tuning
public class Tuning {
    private final String name;
    private final String[] notes;
    private int targetStringIndex = -1;     // Constructor
    public Tuning(String name, String[] notes) {
        this.name = name;
        this.notes = notes;
    }
    public void setTargetStringIndex(int stringIndex) {
        this.targetStringIndex = stringIndex;
    }

    // Getter for the tuning name
    public String getName() {
        return name;
    }

    // Getter for the array of notes
    public String[] getNotes() {
        return notes;
    }

    // This is important for the Spinner to display the name correctly
    @Override
    public String toString() {
        return this.name;
    }
}