package com.gilman.truguitartuner; // Make sure this matches your package name

import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import java.util.Locale;

public class SettingsActivity extends AppCompatActivity {

    private SeekBar seekBarA4;
    private TextView tvA4Value;
    private SharedPreferences preferences;

    public static final String PREF_A4_FREQUENCY = "a4_frequency";
    public static final float DEFAULT_A4_FREQUENCY = 440.0f;
    public static final String PREF_NOTE_DURATION = "note_duration";
    public static final int DEFAULT_NOTE_DURATION = 1;

    private final float MIN_FREQ = 430.0f;
    private final float MAX_FREQ = 450.0f;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_settings);

        if (getSupportActionBar() != null) {
            getSupportActionBar().setTitle("Tuner Settings");
        }

        seekBarA4 = findViewById(R.id.sb_a4_frequency);
        tvA4Value = findViewById(R.id.tv_a4_value);


        preferences = PreferenceManager.getDefaultSharedPreferences(this);

        float currentFreq = preferences.getFloat(PREF_A4_FREQUENCY, DEFAULT_A4_FREQUENCY);

        seekBarA4.setMax((int) ((MAX_FREQ - MIN_FREQ) * 10));
        int progress = (int) ((currentFreq - MIN_FREQ) * 10);
        seekBarA4.setProgress(progress);

        tvA4Value.setText(String.format(Locale.US, "%.1f Hz", currentFreq));

        seekBarA4.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                float newFreq = MIN_FREQ + (progress / 10.0f);
                tvA4Value.setText(String.format(Locale.US, "%.1f Hz", newFreq));
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {}

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                float finalFreq = MIN_FREQ + (seekBar.getProgress() / 10.0f);
                preferences.edit().putFloat(PREF_A4_FREQUENCY, finalFreq).apply();
            }
        });


        // In SettingsActivity.java -> onCreate()

// ... (your existing code for SharedPreferences and the A4 SeekBar)

// --- Add this new code for the Duration SeekBar ---
        TextView tvDurationValue = findViewById(R.id.tv_duration_value);
        SeekBar sbNoteDuration = findViewById(R.id.sb_note_duration);

// Load the saved duration and set the initial state
        int savedDuration = preferences.getInt(PREF_NOTE_DURATION, DEFAULT_NOTE_DURATION);
        tvDurationValue.setText(savedDuration + " s");
        sbNoteDuration.setProgress(savedDuration - 1); // Subtract 1 for the 0-based SeekBar

        sbNoteDuration.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                int currentDuration = progress + 1; // Add 1 to get 1-5 seconds
                tvDurationValue.setText(currentDuration + " s");
                if (fromUser) {
                    preferences.edit().putInt(PREF_NOTE_DURATION, currentDuration).apply();
                }
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) { }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) { }
        });
    }
}