/*
 * Decompiled with CFR 0.152.
 */
package com.mantz_it.guitartunerlibrary;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import com.mantz_it.guitartunerlibrary.DefaultTunerSkin;
import com.mantz_it.guitartunerlibrary.GuitarTuner;
import com.mantz_it.guitartunerlibrary.R;

public class VintageNeedleTunerSkin
extends DefaultTunerSkin {
    private Resources resources;
    private Bitmap scaledBackground;
    private Paint jewelLightPaint;
    private Paint jewelLightHousingPaint;
    private Paint brandTextPaint;
    private Paint knobPaint;
    private Paint knobIndicatorPaint;
    private Paint labelTextPaint;
    private Paint dialBackgroundPaint;

    public VintageNeedleTunerSkin(Resources resources) {
        this.resources = resources;
        this.sideLettersPosition = 0.45f;
        this.maxAngle = 0.6f;
    }

    @Override
    public void updateWidthAndHeight(int width, int height) {
        super.updateWidthAndHeight(width, height);
        this.foregroundPaint.setTextSize((float)height * 0.15f);
        this.invalidPaint.setTextSize((float)height * 0.15f);
        this.highlightPaint.setTextSize((float)height * 0.15f);
        this.gradientPaint.setTextSize((float)height * 0.12f);
        this.gradientPaint.setShader((Shader)new LinearGradient((float)(width / 5), 0.0f, (float)(width / 2), 0.0f, -12303292, -3355444, Shader.TileMode.MIRROR));
        this.highlightPaint.setColor(Color.parseColor((String)"#28C902"));
        this.jewelLightPaint = new Paint(1);
        this.jewelLightPaint.setColor(Color.parseColor((String)"#FF0000"));
        this.jewelLightPaint.setStyle(Paint.Style.FILL);
        this.jewelLightHousingPaint = new Paint(1);
        this.jewelLightHousingPaint.setColor(Color.parseColor((String)"#333333"));
        this.jewelLightHousingPaint.setStyle(Paint.Style.STROKE);
        this.jewelLightHousingPaint.setStrokeWidth(4.0f);
        this.brandTextPaint = new Paint(1);
        this.brandTextPaint.setColor(Color.parseColor((String)"#555555"));
        this.brandTextPaint.setTextSize((float)height * 0.08f);
        this.brandTextPaint.setTextAlign(Paint.Align.CENTER);
        this.brandTextPaint.setFakeBoldText(true);
        this.knobPaint = new Paint(1);
        this.knobPaint.setShader((Shader)new LinearGradient(0.0f, (float)height * 0.7f, 0.0f, (float)height * 0.9f, Color.parseColor((String)"#C0C0C0"), Color.parseColor((String)"#656565"), Shader.TileMode.CLAMP));
        this.knobIndicatorPaint = new Paint(1);
        this.knobIndicatorPaint.setColor(Color.parseColor((String)"#202020"));
        this.knobIndicatorPaint.setStyle(Paint.Style.STROKE);
        this.knobIndicatorPaint.setStrokeWidth(4.0f);
        this.labelTextPaint = new Paint(1);
        this.labelTextPaint.setColor(Color.parseColor((String)"#505050"));
        this.labelTextPaint.setTextSize((float)height * 0.06f);
        this.labelTextPaint.setTextAlign(Paint.Align.CENTER);
        this.dialBackgroundPaint = new Paint(1);
        this.dialBackgroundPaint.setStyle(Paint.Style.FILL);
        if (width > 0 && height > 0) {
            int centerColor = Color.parseColor((String)"#F5F5DC");
            int edgeColor = Color.parseColor((String)"#D2B48C");
            this.dialBackgroundPaint.setShader((Shader)new RadialGradient((float)width / 2.0f, (float)height * 0.45f, (float)width / 1.5f, centerColor, edgeColor, Shader.TileMode.CLAMP));
        }
        this.loadBackground();
    }

    @Override
    public void setRound(boolean round) {
        super.setRound(round);
        this.loadBackground();
    }

    private void loadBackground() {
        if (this.width > 0 && this.height > 0) {
            this.scaledBackground = this.round ? Bitmap.createScaledBitmap((Bitmap)BitmapFactory.decodeResource((Resources)this.resources, (int)R.drawable.vintage_tuner_skin_round), (int)this.width, (int)this.height, (boolean)false) : Bitmap.createScaledBitmap((Bitmap)BitmapFactory.decodeResource((Resources)this.resources, (int)R.drawable.vintage_silver_skin), (int)this.width, (int)this.height, (boolean)false);
        }
    }

    @Override
    public void draw(Canvas c, GuitarTuner tuner) {
        this.draw(c, tuner, 0, 1);
    }

    @Override
    public void draw(Canvas c, GuitarTuner tuner, int frameNumber, int framesPerCycle) {
        c.drawRect(0.0f, 0.0f, (float)this.width, (float)this.height, this.backgroundPaint);
        float dialTop = (float)this.height * 0.2f;
        float dialBottom = (float)this.height * 0.7f;
        float dialLeft = 0.0f;
        float dialRight = this.width;
        c.drawRect(dialLeft, dialTop, dialRight, dialBottom, this.dialBackgroundPaint);
        if (this.scaledBackground != null) {
            c.drawBitmap(this.scaledBackground, 0.0f, 0.0f, null);
        }
        if (tuner.isTuned()) {
            this.jewelLightPaint.setColor(Color.parseColor((String)"#28C902"));
        } else {
            this.jewelLightPaint.setColor(Color.parseColor((String)"#FF0000"));
        }
        float jewelX = (float)this.width * 0.85f;
        float jewelY = (float)this.height * 0.25f;
        float jewelRadius = (float)this.height * 0.05f;
        c.drawCircle(jewelX, jewelY, jewelRadius, this.jewelLightHousingPaint);
        c.drawCircle(jewelX, jewelY, jewelRadius, this.jewelLightPaint);
        c.drawText("SILVERTONE", (float)(this.width / 2), (float)this.height * 0.2f, this.brandTextPaint);
        float knobRadius = (float)this.height * 0.08f;
        float knobY = (float)this.height * 0.8f;
        float labelY = knobY + knobRadius + (float)this.height * 0.07f;
        Paint knobBasePaint = new Paint(1);
        knobBasePaint.setColor(Color.parseColor((String)"#1a1a1a"));
        knobBasePaint.setStyle(Paint.Style.FILL);
        float knob1X = (float)this.width * 0.18f;
        c.drawCircle(knob1X, knobY, knobRadius + 2.0f, knobBasePaint);
        c.drawCircle(knob1X, knobY, knobRadius, this.knobPaint);
        c.drawLine(knob1X, knobY - knobRadius * 0.8f, knob1X, knobY - knobRadius * 0.3f, this.knobIndicatorPaint);
        c.drawText("CALIBRATE", knob1X, labelY, this.labelTextPaint);
        float knob2X = (float)this.width * 0.82f;
        c.drawCircle(knob2X, knobY, knobRadius + 2.0f, knobBasePaint);
        c.drawCircle(knob2X, knobY, knobRadius, this.knobPaint);
        c.save();
        c.rotate(45.0f, knob2X, knobY);
        c.drawLine(knob2X, knobY - knobRadius * 0.8f, knob2X, knobY - knobRadius * 0.3f, this.knobIndicatorPaint);
        c.restore();
        this.drawScale(c);
        if (tuner.isValid() && tuner.getTargetFrequency() > 0.0f) {
            float angle;
            float targetFrequency = tuner.getTargetFrequency();
            int targetPitchIndex = tuner.getTargetPitchIndex();
            String centerLetter = tuner.pitchLetterFromIndex(targetPitchIndex);
            Paint letterPaint = tuner.isTuned() ? this.highlightPaint : this.gradientPaint;
            this.drawPitchLetter(c, centerLetter, 0.0f, 0.48f, true, letterPaint);
            double TUNED_THRESHOLD_CENTS = 2.5;
            double detectedFrequency = tuner.getDetectedFrequency();
            double diffInCents = 1200.0 * Math.log(detectedFrequency / (double)targetFrequency) / Math.log(2.0);
            if (Math.abs(diffInCents) < 2.5) {
                angle = 0.0f;
            } else {
                double clampedDiff = Math.max(-50.0, Math.min(50.0, diffInCents));
                angle = (float)(clampedDiff / 50.0) * this.maxAngle;
            }
            this.drawNeedle(c, angle, tuner.isTuned() ? this.highlightPaint : this.foregroundPaint);
        } else {
            this.drawPitchLetter(c, "---", 0.0f, 0.48f, true, this.invalidPaint);
        }
    }
}

