/*
 * Decompiled with CFR 0.152.
 */
package com.mantz_it.guitartunerlibrary;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.mantz_it.guitartunerlibrary.GuitarTuner;
import com.mantz_it.guitartunerlibrary.NotePlayer;
import com.mantz_it.guitartunerlibrary.TunerSkin;

public class TunerSurface
extends SurfaceView
implements GuitarTuner.GuitarTunerCallbackInterface,
SurfaceHolder.Callback {
    private static final String LOGTAG = "TunerSurface";
    private TunerSkin tunerSkin;
    private int width = -1;
    private int height = -1;
    private boolean round;
    private NotePlayer notePlayer;

    public void setNotePlayer(NotePlayer player) {
        this.notePlayer = player;
    }

    @Override
    public void playNoteWhenTuned(float frequency) {
        if (this.notePlayer != null) {
            this.notePlayer.playNote(frequency);
        }
    }

    public TunerSurface(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.width = width;
        this.height = height;
        if (this.tunerSkin != null) {
            this.tunerSkin.updateWidthAndHeight(width, height);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public void setRound(boolean round) {
        this.round = round;
        if (this.tunerSkin != null) {
            this.tunerSkin.setRound(round);
        }
    }

    public void setTunerSkin(TunerSkin skin) {
        this.tunerSkin = skin;
        this.tunerSkin.updateWidthAndHeight(this.width, this.height);
        this.tunerSkin.setRound(this.round);
    }

    @Override
    public boolean process(GuitarTuner guitarTuner) {
        if (!this.getHolder().getSurface().isValid()) {
            Log.d((String)LOGTAG, (String)"process: Surface is not valid!");
            return false;
        }
        if (this.height < 0 || this.width < 0) {
            Log.d((String)LOGTAG, (String)"process: height and width are not yet set!");
            return false;
        }
        if (this.tunerSkin == null) {
            Log.d((String)LOGTAG, (String)"process: tunerSkin is null!");
            return false;
        }
        if (this.tunerSkin.isAnimationEnabled()) {
            this.animatedDraw(guitarTuner);
        } else {
            this.draw(guitarTuner);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw(GuitarTuner guitarTuner) {
        Canvas c = null;
        try {
            c = this.getHolder().lockCanvas();
            SurfaceHolder surfaceHolder = this.getHolder();
            synchronized (surfaceHolder) {
                if (c != null) {
                    this.tunerSkin.draw(c, guitarTuner);
                } else {
                    Log.d((String)LOGTAG, (String)"draw: Canvas is null.");
                }
            }
        }
        catch (Exception e) {
            Log.e((String)LOGTAG, (String)"draw: Error while drawing on the canvas. Stop!");
            e.printStackTrace();
        }
        finally {
            if (c != null) {
                this.getHolder().unlockCanvasAndPost(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void animatedDraw(GuitarTuner guitarTuner) {
        float updateRate = guitarTuner.getUpdateRate();
        int framesToDraw = (int)((float)this.tunerSkin.getDesiredRefreshRate() / updateRate + 1.0f);
        int millisPerCycle = (int)(1000.0f / updateRate);
        int millisPerFrame = millisPerCycle / framesToDraw;
        long frameStartTime = guitarTuner.getLastUpdateTimestamp();
        for (int i = 0; i < framesToDraw; ++i) {
            if (System.currentTimeMillis() > guitarTuner.getLastUpdateTimestamp() + (long)millisPerCycle) {
                Log.d((String)LOGTAG, (String)"animatedDraw: Exceeded cycle time during animation!");
                return;
            }
            Canvas c = null;
            try {
                c = this.getHolder().lockCanvas();
                SurfaceHolder surfaceHolder = this.getHolder();
                synchronized (surfaceHolder) {
                    if (c != null) {
                        this.tunerSkin.draw(c, guitarTuner, i, framesToDraw);
                    } else {
                        Log.d((String)LOGTAG, (String)"animatedDraw: Canvas is null.");
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)LOGTAG, (String)("animatedDraw: Error while drawing on the canvas: " + e.getMessage()));
            }
            finally {
                if (c != null) {
                    this.getHolder().unlockCanvasAndPost(c);
                }
            }
            int sleepTime = (int)(frameStartTime + (long)millisPerFrame - System.currentTimeMillis());
            if (sleepTime > 0) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    Log.d((String)LOGTAG, (String)("animatedDraw: Interrupted while waiting for the next frame: " + e.getMessage()));
                    return;
                }
            }
            frameStartTime += (long)millisPerFrame;
        }
    }
}

