/*
 * Decompiled with CFR 0.152.
 */
package com.mantz_it.guitartunerlibrary;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import com.mantz_it.guitartunerlibrary.GuitarTuner;
import com.mantz_it.guitartunerlibrary.TunerSkin;

public class TunerSkinVintagePro
extends TunerSkin {
    private Paint backgroundPaint;
    private Paint meterCasePaint;
    private Paint meterFacePaint;
    private Paint meterArchPaint;
    private Paint textPaint;
    private Paint needlePaint;
    private Paint inTunePaint;
    private Paint lightOffPaint;
    private Paint lightOnPaint;
    private Paint markingsPaint;
    private Paint logoPaint;
    private RectF meterCaseRect;
    private RectF meterFaceRect;
    private Path meterArchPath;
    private Path textArcPath;
    private float centerX;
    private float centerY;
    private float needlePivotX;
    private float needlePivotY;
    private float needleLength;
    private float lightCenterX;
    private float lightCenterY;
    private float lightRadius;
    private Paint accentMarkingsPaint;

    public TunerSkinVintagePro() {
        this.init();
    }

    public void init() {
        this.backgroundPaint = new Paint();
        this.backgroundPaint.setColor(Color.parseColor((String)"#1C1C1C"));
        this.backgroundPaint.setStyle(Paint.Style.FILL);
        this.meterCasePaint = new Paint();
        this.meterCasePaint.setAntiAlias(true);
        this.meterFacePaint = new Paint();
        this.meterFacePaint.setColor(Color.parseColor((String)"#DDCDBA"));
        this.meterFacePaint.setAntiAlias(true);
        this.meterArchPaint = new Paint();
        this.meterArchPaint.setColor(-16777216);
        this.meterArchPaint.setStyle(Paint.Style.STROKE);
        this.meterArchPaint.setStrokeWidth(8.0f);
        this.meterArchPaint.setAntiAlias(true);
        this.textPaint = new Paint();
        this.textPaint.setColor(-16777216);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setFakeBoldText(true);
        this.markingsPaint = new Paint();
        this.markingsPaint.setColor(Color.parseColor((String)"#333333"));
        this.markingsPaint.setTextAlign(Paint.Align.LEFT);
        this.markingsPaint.setAntiAlias(true);
        this.markingsPaint.setTextSize(40.0f);
        this.logoPaint = new Paint();
        this.logoPaint.setColor(Color.parseColor((String)"#4A4A4A"));
        this.logoPaint.setAntiAlias(true);
        this.logoPaint.setTextAlign(Paint.Align.CENTER);
        this.logoPaint.setTextSize(55.0f);
        this.logoPaint.setTypeface(Typeface.create((Typeface)Typeface.SERIF, (int)2));
        this.accentMarkingsPaint = new Paint();
        this.accentMarkingsPaint.setColor(Color.parseColor((String)"#E53935"));
        this.accentMarkingsPaint.setTextAlign(Paint.Align.LEFT);
        this.accentMarkingsPaint.setAntiAlias(true);
        this.accentMarkingsPaint.setTextSize(40.0f);
        this.accentMarkingsPaint.setFakeBoldText(true);
        this.needlePaint = new Paint();
        this.needlePaint.setColor(-16777216);
        this.needlePaint.setStrokeWidth(6.0f);
        this.needlePaint.setStrokeCap(Paint.Cap.ROUND);
        this.needlePaint.setAntiAlias(true);
        this.inTunePaint = new Paint();
        this.inTunePaint.setColor(Color.parseColor((String)"#E53935"));
        this.inTunePaint.setStrokeWidth(8.0f);
        this.inTunePaint.setStrokeCap(Paint.Cap.ROUND);
        this.inTunePaint.setAntiAlias(true);
        this.lightOffPaint = new Paint();
        this.lightOffPaint.setColor(Color.parseColor((String)"#4C1A1A"));
        this.lightOffPaint.setAntiAlias(true);
        this.lightOnPaint = new Paint();
        this.lightOnPaint.setAntiAlias(true);
    }

    @Override
    public void updateWidthAndHeight(int width, int height) {
        super.updateWidthAndHeight(width, height);
        if (width == 0 || height == 0) {
            return;
        }
        this.centerX = (float)width / 2.0f;
        this.centerY = (float)height / 2.0f;
        float caseWidth = (float)width * 0.9f;
        float caseHeight = (float)height * 0.7f;
        float caseLeft = ((float)width - caseWidth) / 2.0f;
        float caseTop = ((float)height - caseHeight) / 2.0f;
        this.meterCaseRect = new RectF(caseLeft, caseTop, caseLeft + caseWidth, caseTop + caseHeight);
        LinearGradient caseGradient = new LinearGradient(caseLeft, caseTop, caseLeft + caseWidth, caseTop + caseHeight, Color.parseColor((String)"#F5EEDC"), Color.parseColor((String)"#D4C4A8"), Shader.TileMode.CLAMP);
        this.meterCasePaint.setShader((Shader)caseGradient);
        float faceLeft = this.meterCaseRect.left + this.meterCaseRect.width() * 0.08f;
        float faceRight = this.meterCaseRect.right - this.meterCaseRect.width() * 0.08f;
        float faceBottom = this.meterCaseRect.bottom - this.meterCaseRect.height() * 0.25f;
        float faceTop = this.meterCaseRect.top + this.meterCaseRect.height() * 0.08f;
        this.meterFaceRect = new RectF(faceLeft, faceTop, faceRight, faceBottom);
        this.meterArchPath = new Path();
        RectF arcBounds = new RectF(faceLeft, faceTop, faceRight, faceBottom);
        this.meterArchPath.moveTo(faceLeft, faceBottom);
        this.meterArchPath.arcTo(arcBounds, 180.0f, 180.0f, false);
        this.meterArchPath.lineTo(faceRight, faceBottom);
        this.meterArchPath.close();
        this.textArcPath = new Path();
        RectF textArcBounds = new RectF(this.meterFaceRect.left - this.meterFaceRect.width() * 0.05f, this.meterFaceRect.top, this.meterFaceRect.right + this.meterFaceRect.width() * 0.05f, this.meterFaceRect.bottom);
        this.textArcPath.addArc(textArcBounds, 180.0f, 180.0f);
        this.needlePivotX = this.centerX;
        this.needlePivotY = faceBottom;
        this.needleLength = this.meterFaceRect.height() * 0.8f;
        this.lightRadius = (float)width * 0.03f;
        this.lightCenterX = this.meterCaseRect.right - this.lightRadius * 2.5f;
        this.lightCenterY = this.meterCaseRect.top + this.lightRadius * 2.5f;
    }

    private void drawTextDistributed(Canvas canvas, String text, Path path, float startOffset, float totalWidth, float vOffset, Paint paint) {
        if (text.length() < 2) {
            float textWidth = paint.measureText(text);
            canvas.drawTextOnPath(text, path, startOffset + (totalWidth - textWidth) / 2.0f, vOffset, paint);
            return;
        }
        float spacing = totalWidth / (float)(text.length() - 1);
        float currentOffset = startOffset;
        for (char c : text.toCharArray()) {
            String character = String.valueOf(c);
            float charWidth = paint.measureText(character);
            canvas.drawTextOnPath(character, path, currentOffset - charWidth / 2.0f, vOffset, paint);
            currentOffset += spacing;
        }
    }

    @Override
    public void draw(Canvas canvas, GuitarTuner tuner) {
        if (this.meterCaseRect == null) {
            return;
        }
        canvas.drawPaint(this.backgroundPaint);
        canvas.drawRoundRect(this.meterCaseRect, 20.0f, 20.0f, this.meterCasePaint);
        canvas.drawPath(this.meterArchPath, this.meterFacePaint);
        if (this.textArcPath != null) {
            this.markingsPaint.setTextSize(this.meterFaceRect.height() * 0.15f);
            this.markingsPaint.setFakeBoldText(true);
            this.markingsPaint.setLetterSpacing(0.0f);
            PathMeasure pm = new PathMeasure(this.textArcPath, false);
            float textPathLength = pm.getLength();
            float vOffset = this.markingsPaint.getTextSize() * 2.5f;
            float distributionWidth = textPathLength * 0.5f;
            float startOffset = (textPathLength - distributionWidth) / 2.0f;
            this.drawTextDistributed(canvas, "NORMAL", this.textArcPath, startOffset, distributionWidth, vOffset, this.markingsPaint);
            this.accentMarkingsPaint.setTextSize(this.markingsPaint.getTextSize());
            float minusTextWidth = this.accentMarkingsPaint.measureText("-");
            float hOffsetMinus = textPathLength * 0.08f - minusTextWidth / 2.0f;
            canvas.drawTextOnPath("-", this.textArcPath, hOffsetMinus, vOffset, this.accentMarkingsPaint);
            float plusTextWidth = this.accentMarkingsPaint.measureText("+");
            float hOffsetPlus = textPathLength * 0.92f - plusTextWidth / 2.0f;
            canvas.drawTextOnPath("+", this.textArcPath, hOffsetPlus, vOffset, this.accentMarkingsPaint);
            float tickYStart = this.meterFaceRect.top + this.meterFaceRect.height() * 0.05f;
            float tickYEnd = tickYStart + this.meterFaceRect.height() * 0.15f;
            canvas.drawLine(this.centerX, tickYStart, this.centerX, tickYEnd, this.markingsPaint);
        }
        this.logoPaint.setTextSize(this.meterFaceRect.height() * 0.22f);
        canvas.drawText("Silvertone", this.centerX, this.needlePivotY - this.logoPaint.getTextSize() * 0.5f, this.logoPaint);
        canvas.drawPath(this.meterArchPath, this.meterArchPaint);
        if (tuner.isValid()) {
            this.textPaint.setTextSize(this.meterCaseRect.height() * 0.15f);
            String noteName = tuner.pitchLetterFromIndex(tuner.getTargetPitchIndex());
            canvas.drawText(noteName, this.centerX, this.meterCaseRect.bottom - this.meterCaseRect.height() * 0.05f, this.textPaint);
        }
        if (tuner.isValid()) {
            float cents = (float)(1200.0 * Math.log(tuner.getDetectedFrequency() / tuner.getTargetFrequency()) / Math.log(2.0));
            cents = Math.max(-50.0f, Math.min(50.0f, cents));
            float rotationAngle = cents / 50.0f * 60.0f;
            canvas.save();
            canvas.rotate(rotationAngle, this.needlePivotX, this.needlePivotY);
            Paint currentNeedlePaint = tuner.isTuned() ? this.inTunePaint : this.needlePaint;
            canvas.drawLine(this.needlePivotX, this.needlePivotY, this.needlePivotX, this.needlePivotY - this.needleLength, currentNeedlePaint);
            canvas.restore();
        }
        canvas.drawCircle(this.needlePivotX, this.needlePivotY, 15.0f, this.meterArchPaint);
        if (this.lightRadius > 0.0f) {
            canvas.drawCircle(this.lightCenterX, this.lightCenterY, this.lightRadius, this.lightOffPaint);
            if (tuner.isValid()) {
                RadialGradient lightGradient = new RadialGradient(this.lightCenterX, this.lightCenterY, this.lightRadius, Color.parseColor((String)"#FF8A80"), Color.parseColor((String)"#E53935"), Shader.TileMode.CLAMP);
                this.lightOnPaint.setShader((Shader)lightGradient);
                canvas.drawCircle(this.lightCenterX, this.lightCenterY, this.lightRadius, this.lightOnPaint);
            }
        }
    }
}

