/*
 * Decompiled with CFR 0.152.
 */
package com.mantz_it.guitartunerlibrary;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import com.mantz_it.guitartunerlibrary.GuitarTuner;
import com.mantz_it.guitartunerlibrary.TunerSkin;
import java.util.Locale;

public class TunerSkinFilmLeader
extends TunerSkin {
    private Paint linePaint;
    private Paint backgroundPaint;
    private Paint textPaint;
    private Paint needlePaint;
    private Paint inTunePaint;
    private Paint numberBoxPaint;
    private float centerX;
    private float centerY;
    private float radius;

    public TunerSkinFilmLeader() {
        this.init();
    }

    private void init() {
        this.backgroundPaint = new Paint();
        this.backgroundPaint.setColor(-16777216);
        this.backgroundPaint.setStyle(Paint.Style.FILL);
        this.linePaint = new Paint();
        this.linePaint.setColor(-1);
        this.linePaint.setStrokeWidth(4.0f);
        this.linePaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setAntiAlias(true);
        this.textPaint = new Paint();
        this.textPaint.setColor(-1);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setTypeface(Typeface.create((Typeface)Typeface.MONOSPACE, (int)1));
        this.needlePaint = new Paint();
        this.needlePaint.setColor(-65536);
        this.needlePaint.setStrokeWidth(12.0f);
        this.needlePaint.setStyle(Paint.Style.STROKE);
        this.needlePaint.setAntiAlias(true);
        this.inTunePaint = new Paint();
        this.inTunePaint.setColor(-16711936);
        this.inTunePaint.setStrokeWidth(16.0f);
        this.inTunePaint.setStyle(Paint.Style.STROKE);
        this.inTunePaint.setAntiAlias(true);
        this.numberBoxPaint = new Paint();
        this.numberBoxPaint.setStyle(Paint.Style.FILL);
        this.numberBoxPaint.setAntiAlias(true);
    }

    @Override
    public void updateWidthAndHeight(int width, int height) {
        super.updateWidthAndHeight(width, height);
        this.centerX = (float)width / 2.0f;
        this.centerY = (float)height / 2.0f;
        this.radius = (float)Math.min(width, height) * 0.4f;
        LinearGradient backgroundGradient = new LinearGradient(this.centerX, 0.0f, this.centerX, (float)height, -7829368, -12303292, Shader.TileMode.CLAMP);
        this.numberBoxPaint.setShader((Shader)backgroundGradient);
    }

    @Override
    public void draw(Canvas canvas, GuitarTuner tuner) {
        int i;
        canvas.drawRect(0.0f, 0.0f, (float)this.width, (float)this.height, this.backgroundPaint);
        float filmstripWidth = (float)this.width * 0.9f;
        float filmstripLeft = this.centerX - filmstripWidth / 2.0f;
        float filmstripRight = this.centerX + filmstripWidth / 2.0f;
        RectF filmstripRect = new RectF(filmstripLeft, 0.0f, filmstripRight, (float)this.height);
        canvas.drawRect(filmstripRect, this.numberBoxPaint);
        float sprocketSize = (float)this.width * 0.03f;
        float sprocketMargin = sprocketSize / 2.0f;
        int numSprockets = (int)((float)this.height / (sprocketSize * 2.5f));
        for (i = 0; i < numSprockets; ++i) {
            float y = (float)i * sprocketSize * 2.5f + sprocketSize;
            canvas.drawRect(sprocketMargin, y, sprocketMargin + sprocketSize, y + sprocketSize, this.numberBoxPaint);
            canvas.drawRect((float)this.width - sprocketMargin - sprocketSize, y, (float)this.width - sprocketMargin, y + sprocketSize, this.numberBoxPaint);
        }
        this.linePaint.setStrokeWidth(4.0f);
        canvas.drawCircle(this.centerX, this.centerY, this.radius, this.linePaint);
        canvas.drawCircle(this.centerX, this.centerY, this.radius * 0.9f, this.linePaint);
        this.linePaint.setColor(-16777216);
        canvas.drawLine(filmstripLeft, this.centerY, filmstripRight, this.centerY, this.linePaint);
        canvas.drawLine(this.centerX, 0.0f, this.centerX, (float)this.height, this.linePaint);
        this.linePaint.setColor(-1);
        this.textPaint.setTextSize(this.radius * 0.25f);
        this.textPaint.setColor(Color.parseColor((String)"#555555"));
        for (i = 1; i <= 8; ++i) {
            double angle = 0.7853981633974483 * (double)(i - 2);
            float numberRadius = this.radius * 0.7f;
            float x = this.centerX + (float)(Math.cos(angle) * (double)numberRadius);
            float y = this.centerY + (float)(Math.sin(angle) * (double)numberRadius) + this.textPaint.getTextSize() / 3.0f;
            canvas.drawText(String.valueOf(9 - i), x, y, this.textPaint);
        }
        if (tuner.isValid()) {
            this.textPaint.setColor(tuner.isTuned() ? -16711936 : -16777216);
            this.textPaint.setTextSize(this.radius * 0.5f);
            canvas.drawText(tuner.pitchLetterFromIndex(tuner.getTargetPitchIndex()), this.centerX, this.centerY - this.radius * 0.2f, this.textPaint);
            this.textPaint.setTextSize(this.radius * 0.2f);
            String freqText = String.format(Locale.US, "%.2f Hz", Float.valueOf(tuner.getDetectedFrequency()));
            canvas.drawText(freqText, this.centerX, this.centerY + this.radius * 0.4f, this.textPaint);
            float frequency = tuner.getDetectedFrequency();
            float targetFreq = tuner.getTargetFrequency();
            float cents = (float)(1200.0 * Math.log(frequency / targetFreq) / Math.log(2.0));
            cents = Math.max(-50.0f, Math.min(50.0f, cents));
            float rotationAngle = cents / 50.0f * 45.0f;
            canvas.save();
            canvas.rotate(rotationAngle, this.centerX, this.centerY);
            Paint needleColorPaint = tuner.isTuned() ? this.inTunePaint : this.backgroundPaint;
            needleColorPaint.setStrokeWidth(8.0f);
            canvas.drawLine(this.centerX, this.centerY, this.centerX, this.centerY - this.radius * 0.85f, needleColorPaint);
            canvas.restore();
        } else {
            this.textPaint.setColor(-16777216);
            this.textPaint.setTextSize(this.radius * 0.5f);
            canvas.drawText("-", this.centerX, this.centerY - this.radius * 0.2f, this.textPaint);
        }
        this.linePaint.setStrokeWidth(8.0f);
        this.linePaint.setColor(-1);
        canvas.drawLine(this.centerX, this.centerY - this.radius * 0.9f, this.centerX, this.centerY - this.radius * 1.1f, this.linePaint);
        this.textPaint.setColor(-1);
    }
}

