/*
 * Decompiled with CFR 0.152.
 */
package com.mantz_it.guitartunerlibrary;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.Log;
import com.mantz_it.guitartunerlibrary.DebugTunerSkin;
import com.mantz_it.guitartunerlibrary.DefaultTunerSkin;
import com.mantz_it.guitartunerlibrary.GuitarTuner;
import com.mantz_it.guitartunerlibrary.NixieTubeTunerSkin;
import com.mantz_it.guitartunerlibrary.R;
import com.mantz_it.guitartunerlibrary.TunerSkinFilmLeader;
import com.mantz_it.guitartunerlibrary.TunerSkinVintagePro;

public abstract class TunerSkin {
    protected Paint backgroundPaint = new Paint();
    protected Paint foregroundPaint;
    protected Paint highlightPaint;
    protected Paint invalidPaint;
    protected int width;
    protected int height;
    protected boolean round = false;
    protected int desiredRefreshRate = 30;
    protected boolean animationEnabled = false;

    public TunerSkin() {
        this.backgroundPaint.setColor(-16777216);
        this.foregroundPaint = new Paint();
        this.foregroundPaint.setColor(-1);
        this.foregroundPaint.setAntiAlias(true);
        this.highlightPaint = new Paint();
        this.highlightPaint.setColor(-65536);
        this.highlightPaint.setAntiAlias(true);
        this.invalidPaint = new Paint();
        this.invalidPaint.setColor(-7829368);
        this.invalidPaint.setAntiAlias(true);
    }

    public void updateWidthAndHeight(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setRound(boolean round) {
        this.round = round;
    }

    public void setDesiredRefreshRate(int refreshRateInMs) {
        this.desiredRefreshRate = refreshRateInMs;
    }

    public int getDesiredRefreshRate() {
        return this.desiredRefreshRate;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled && this.desiredRefreshRate > 0;
    }

    public abstract void draw(Canvas var1, GuitarTuner var2);

    public void draw(Canvas c, GuitarTuner tuner, int frameNumber, int framesPerCycle) {
        Log.w((String)"TunerSkin", (String)"draw: Animated draw is not supported by this skin!");
        this.draw(c, tuner);
    }

    public static int getTunerSkinCount() {
        return 5;
    }

    public static TunerSkin getTunerSkinInstance(int skinIndex, Activity activity) {
        switch (skinIndex) {
            case 0: {
                return new DefaultTunerSkin();
            }
            case 1: {
                return new TunerSkinVintagePro();
            }
            case 2: {
                return new NixieTubeTunerSkin((Context)activity);
            }
            case 3: {
                return new DebugTunerSkin();
            }
            case 4: {
                return new TunerSkinFilmLeader();
            }
        }
        return null;
    }

    public static int getTunerSkinThumbnailResource(int skinIndex, boolean round) {
        switch (skinIndex) {
            case 0: {
                return round ? R.drawable.thumbnail_default_skin_round : R.drawable.thumbnail_default_skin;
            }
            case 1: {
                return round ? R.drawable.thumbnail_vintage_needle_skin_round : R.drawable.thumbnail_vintage_skin;
            }
            case 2: {
                return round ? R.drawable.thumbnail_debug_skin_rect : R.drawable.thumbnail_nixie_tube_skin;
            }
            case 3: {
                return round ? R.drawable.thumbnail_debug_skin_round : R.drawable.thumbnail_debug_skin;
            }
            case 4: {
                return round ? R.drawable.thumbnail_debug_skin_round : R.drawable.thumbnail_debug_skin;
            }
        }
        return -1;
    }

    public static String getTunerSkinName(int skinIndex) {
        switch (skinIndex) {
            case 0: {
                return "Default Skin";
            }
            case 1: {
                return "Vintage Needle Skin";
            }
            case 2: {
                return "Debug Skin";
            }
            case 3: {
                return "Nixie Tube Skin";
            }
        }
        return null;
    }
}

