/*
 * Decompiled with CFR 0.152.
 */
package com.mantz_it.guitartunerlibrary;

import android.content.SharedPreferences;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class PreferenceSyncHelper {
    private static final String LOGTAG = "PreferenceSyncHelper";

    public static boolean handleSyncMessage(SharedPreferences.Editor edit, String messagePath, byte[] messageData) {
        String[] splitPath = messagePath.split("/");
        String type = splitPath[2];
        String prefKey = splitPath[3];
        String newValue = null;
        if (type.equals("boolean")) {
            Boolean newBool = messageData[0] > 0;
            newValue = "" + newBool;
            edit.putBoolean(prefKey, newBool.booleanValue());
        } else if (type.equals("integer")) {
            Integer newInt = ByteBuffer.wrap(messageData).getInt();
            newValue = "" + newInt;
            edit.putInt(prefKey, newInt.intValue());
        } else if (type.equals("long")) {
            Long newLong = ByteBuffer.wrap(messageData).getLong();
            newValue = "" + newLong;
            edit.putLong(prefKey, newLong.longValue());
        } else if (type.equals("float")) {
            Float newFloat = Float.valueOf(ByteBuffer.wrap(messageData).getFloat());
            newValue = "" + newFloat;
            edit.putFloat(prefKey, newFloat.floatValue());
        } else if (type.equals("string")) {
            try {
                newValue = new String(messageData, "UTF-8");
                edit.putString(prefKey, newValue);
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)LOGTAG, (String)("handleSyncMessage: Failed to extract String: " + e.getMessage()));
            }
        } else {
            Log.d((String)LOGTAG, (String)("handleSyncMessage: Received a syncPref message with unknown type: " + type));
            return false;
        }
        Log.d((String)LOGTAG, (String)("handleSyncMessage: Received a syncPref message. Type is " + type + ". New value is " + newValue));
        edit.apply();
        return true;
    }
}

