/*
 * Decompiled with CFR 0.152.
 */
package com.mantz_it.guitartunerlibrary;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import androidx.core.content.res.ResourcesCompat;
import com.mantz_it.guitartunerlibrary.DefaultTunerSkin;
import com.mantz_it.guitartunerlibrary.GuitarTuner;
import com.mantz_it.guitartunerlibrary.R;

public class NixieTubeTunerSkin
extends DefaultTunerSkin {
    private Paint backgroundPaint;
    private Paint glassTubePaint;
    private Paint glassGlarePaint;
    private Context context;
    private Paint unlitTextPaint;
    private Paint litTextPaint;
    private Paint glowTextPaint;
    private Paint sharpFlatPaint;
    private Paint sharpFlatGlowPaint;
    private Paint inTuneLightPaint;
    private Typeface nixieFont;

    public NixieTubeTunerSkin(Context context) {
        this.context = context;
    }

    @Override
    public void updateWidthAndHeight(int width, int height) {
        super.updateWidthAndHeight(width, height);
        if (width <= 0 || height <= 0) {
            this.backgroundPaint = new Paint();
            this.glassTubePaint = new Paint();
            this.glassGlarePaint = new Paint();
            this.litTextPaint = new Paint();
            this.glowTextPaint = new Paint();
            this.unlitTextPaint = new Paint();
            this.sharpFlatPaint = new Paint();
            this.sharpFlatGlowPaint = new Paint();
            this.inTuneLightPaint = new Paint();
            return;
        }
        try {
            this.nixieFont = ResourcesCompat.getFont((Context)this.context, (int)R.font.dseg7_00_normal);
        }
        catch (Exception e) {
            this.nixieFont = Typeface.create((Typeface)Typeface.MONOSPACE, (int)1);
        }
        this.backgroundPaint = new Paint(1);
        this.backgroundPaint.setStyle(Paint.Style.FILL);
        this.backgroundPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)height, Color.parseColor((String)"#212121"), Color.parseColor((String)"#424242"), Shader.TileMode.CLAMP));
        this.glassTubePaint = new Paint(1);
        this.glassTubePaint.setStyle(Paint.Style.FILL);
        this.glassTubePaint.setColor(Color.argb((int)40, (int)50, (int)50, (int)50));
        this.glassGlarePaint = new Paint(1);
        this.glassGlarePaint.setStyle(Paint.Style.STROKE);
        this.glassGlarePaint.setColor(Color.argb((int)60, (int)255, (int)255, (int)255));
        this.glassGlarePaint.setStrokeWidth((float)height * 0.01f);
        int nixieOrange = Color.parseColor((String)"#FF7A00");
        this.litTextPaint = new Paint(1);
        this.litTextPaint.setTypeface(this.nixieFont);
        this.litTextPaint.setColor(nixieOrange);
        this.litTextPaint.setTextAlign(Paint.Align.CENTER);
        this.litTextPaint.setTextSize((float)height * 0.3f);
        this.glowTextPaint = new Paint(1);
        this.glowTextPaint.set(this.litTextPaint);
        this.glowTextPaint.setColor(nixieOrange);
        this.glowTextPaint.setMaskFilter((MaskFilter)new BlurMaskFilter((float)height * 0.05f, BlurMaskFilter.Blur.NORMAL));
        this.unlitTextPaint = new Paint(1);
        this.unlitTextPaint.setTypeface(this.nixieFont);
        this.unlitTextPaint.setColor(Color.argb((int)50, (int)100, (int)100, (int)100));
        this.unlitTextPaint.setTextAlign(Paint.Align.CENTER);
        this.unlitTextPaint.setTextSize((float)height * 0.3f);
        int indicatorRed = Color.parseColor((String)"#F44336");
        this.sharpFlatPaint = new Paint(1);
        this.sharpFlatPaint.setTypeface(this.nixieFont);
        this.sharpFlatPaint.setColor(indicatorRed);
        this.sharpFlatPaint.setTextAlign(Paint.Align.CENTER);
        this.sharpFlatPaint.setTextSize((float)height * 0.15f);
        this.sharpFlatGlowPaint = new Paint(1);
        this.sharpFlatGlowPaint.set(this.sharpFlatPaint);
        this.sharpFlatGlowPaint.setColor(indicatorRed);
        this.sharpFlatGlowPaint.setMaskFilter((MaskFilter)new BlurMaskFilter((float)height * 0.03f, BlurMaskFilter.Blur.NORMAL));
        this.inTuneLightPaint = new Paint(1);
        this.inTuneLightPaint.setColor(Color.parseColor((String)"#4CAF50"));
        this.inTuneLightPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    public void draw(Canvas c, GuitarTuner tuner, int frameNumber, int framesPerCycle) {
        if (this.backgroundPaint == null || this.litTextPaint == null) {
            return;
        }
        c.drawRect(0.0f, 0.0f, (float)this.width, (float)this.height, this.backgroundPaint);
        float centerX = (float)this.width / 2.0f;
        float centerY = (float)this.height / 2.0f;
        float inTuneLightY = (float)this.height * 0.15f;
        float inTuneLightRadius = (float)this.height * 0.03f;
        String noteText = tuner.isValid() && tuner.getTargetFrequency() > 0.0f ? tuner.pitchLetterFromIndex(tuner.getTargetPitchIndex()) : "---";
        float textWidth = this.litTextPaint.measureText("88");
        float desiredTubeWidth = textWidth * 1.5f;
        float maxTubeWidth = (float)this.width * 0.6f;
        float tubeWidth = Math.min(desiredTubeWidth, maxTubeWidth);
        float tubeHeight = this.litTextPaint.getTextSize() * 1.2f;
        float cornerRadius = (float)this.width * 0.05f;
        RectF tubeRect = new RectF(centerX - tubeWidth / 2.0f, centerY - tubeHeight / 2.0f, centerX + tubeWidth / 2.0f, centerY + tubeHeight / 2.0f);
        c.drawRoundRect(tubeRect, cornerRadius, cornerRadius, this.glassTubePaint);
        c.drawRoundRect(tubeRect, cornerRadius, cornerRadius, this.glassGlarePaint);
        float textCenterY = centerY - (this.litTextPaint.descent() + this.litTextPaint.ascent()) / 2.0f;
        if (tuner.isValid() && tuner.getTargetFrequency() > 0.0f) {
            if (noteText.contains("#")) {
                String mainNotePart = noteText.substring(0, noteText.length() - 1);
                String sharpPart = "#";
                float mainPartWidth = this.litTextPaint.measureText(mainNotePart);
                float sharpWidth = this.litTextPaint.measureText(sharpPart);
                float totalWidth = mainPartWidth + sharpWidth;
                float mainPartX = centerX - totalWidth / 2.0f + mainPartWidth / 2.0f;
                float sharpX = mainPartX + mainPartWidth / 2.0f + sharpWidth / 2.0f;
                c.drawText("88", mainPartX, textCenterY, this.unlitTextPaint);
                c.drawText(mainNotePart, mainPartX, textCenterY, this.glowTextPaint);
                c.drawText(mainNotePart, mainPartX, textCenterY, this.litTextPaint);
                c.drawText(sharpPart, sharpX, textCenterY, this.glowTextPaint);
                c.drawText(sharpPart, sharpX, textCenterY, this.litTextPaint);
            } else {
                c.drawText("88", centerX, textCenterY, this.unlitTextPaint);
                c.drawText(noteText, centerX, textCenterY, this.glowTextPaint);
                c.drawText(noteText, centerX, textCenterY, this.litTextPaint);
            }
            float sharpFlatY = centerY + this.litTextPaint.getTextSize() * 0.2f;
            float indicatorXOffset = (float)this.width * 0.4f;
            float sharpX = centerX + indicatorXOffset;
            float flatX = centerX - indicatorXOffset;
            double diffInCents = 1200.0 * Math.log(tuner.getDetectedFrequency() / tuner.getTargetFrequency()) / Math.log(2.0);
            double INDICATOR_THRESHOLD = 5.0;
            if (tuner.isTuned()) {
                c.drawCircle(centerX, inTuneLightY, inTuneLightRadius, this.inTuneLightPaint);
            } else if (diffInCents < -5.0) {
                c.drawText("\u266d", flatX, sharpFlatY, this.sharpFlatGlowPaint);
                c.drawText("\u266d", flatX, sharpFlatY, this.sharpFlatPaint);
            } else if (diffInCents > 5.0) {
                c.drawText("\u266f", sharpX, sharpFlatY, this.sharpFlatGlowPaint);
                c.drawText("\u266f", sharpX, sharpFlatY, this.sharpFlatPaint);
            }
        } else {
            c.drawText(noteText, centerX, textCenterY, this.glowTextPaint);
            c.drawText(noteText, centerX, textCenterY, this.litTextPaint);
        }
    }

    @Override
    public void draw(Canvas c, GuitarTuner tuner) {
        this.draw(c, tuner, 0, 1);
    }
}

