/*
 * Decompiled with CFR 0.152.
 */
package com.mantz_it.guitartunerlibrary;

import android.os.Vibrator;
import android.util.Log;
import java.util.Locale;

public class GuitarTuner {
    private static final String LOGTAG = "GuitarTuner";
    private static final int LOW_CUT_OFF_FREQUENCY = 50;
    private static final int HIGH_CUT_OFF_FREQUENCY = 2500;
    private float CONCERT_PITCH = 440.0f;
    private static final int HPS_ORDER = 3;
    private static final long[] VIBRATE_PATTERN_UP = new long[]{0L, 200L};
    private static final long[] VIBRATE_PATTERN_DOWN = new long[]{0L, 200L, 200L, 200L};
    private static final long[] VIBRATE_PATTERN_TUNED = new long[]{0L, 100L, 100L, 100L, 100L, 100L};
    private GuitarTunerCallbackInterface callbackInterface;
    private Vibrator vibrator;
    private boolean playNoteOn = false;
    private float[] mag;
    private float[] hps;
    private float updateRate;
    private long lastUpdateTimestamp;
    private float hzPerSample;
    private float strongestFrequency;
    private float detectedFrequency;
    private float targetFrequency;
    private int targetPitchIndex;
    private int pitchHoldCounter = 0;
    private float lastDetectedFrequency;
    private float lastTargetFrequency;
    public boolean valid;
    private boolean vibrate = false;
    private int lowCutOffFrequency = 80;

    public GuitarTuner(GuitarTunerCallbackInterface callbackInterface, Vibrator vibrator) {
        this.callbackInterface = callbackInterface;
        this.vibrator = vibrator;
    }

    public void setTargetFrequency(float freq) {
        this.targetFrequency = freq;
    }

    public boolean processFFTSamples(float[] mag, int sampleRate, float updateRate) {
        this.lastUpdateTimestamp = System.currentTimeMillis();
        this.updateRate = updateRate;
        this.mag = mag;
        this.hzPerSample = (float)(sampleRate / 2) / (float)mag.length;
        int rawMaxIndex = 0;
        for (int i = 1; i < mag.length; ++i) {
            if (!(mag[rawMaxIndex] < mag[i])) continue;
            rawMaxIndex = i;
        }
        float RAW_NOISE_THRESHOLD_DB = -65.0f;
        if (mag[rawMaxIndex] < -65.0f) {
            this.valid = false;
            this.callbackInterface.process(this);
            return true;
        }
        int i = 0;
        while ((float)i < 80.0f / this.hzPerSample) {
            mag[i] = Float.NEGATIVE_INFINITY;
            ++i;
        }
        for (i = (int)(2500.0f / this.hzPerSample); i < mag.length; ++i) {
            mag[i] = Float.NEGATIVE_INFINITY;
        }
        if (this.hps == null || this.hps.length != mag.length) {
            this.hps = new float[mag.length];
        }
        this.calcHarmonicProductSpectrum(mag, this.hps, 3);
        int maxIndex = 0;
        for (int i2 = 1; i2 < this.hps.length; ++i2) {
            if (!(this.hps[maxIndex] < this.hps[i2])) continue;
            maxIndex = i2;
        }
        this.detectedFrequency = this.strongestFrequency = (float)maxIndex * this.hzPerSample;
        if (this.targetFrequency <= 0.0f) {
            this.targetPitchIndex = this.frequencyToPitchIndex(this.detectedFrequency);
            this.targetFrequency = this.pitchIndexToFrequency(this.targetPitchIndex);
        } else {
            this.targetPitchIndex = this.frequencyToPitchIndex(this.targetFrequency);
        }
        if (this.detectedFrequency > this.getLowerToleranceBoundaryFrequency(this.targetPitchIndex) && this.detectedFrequency < this.getUpperToleranceBoundaryFrequency(this.targetPitchIndex)) {
            this.detectedFrequency = this.targetFrequency;
            Log.d((String)LOGTAG, (String)"Snap to Zero: Note is tuned, snapping needle to center.");
        }
        boolean bl = this.valid = this.detectedFrequency >= this.pitchIndexToFrequency(0);
        this.pitchHoldCounter = (double)this.detectedFrequency > (double)this.lastDetectedFrequency * 0.99 && (double)this.detectedFrequency < (double)this.lastDetectedFrequency * 1.01 ? ++this.pitchHoldCounter : 0;
        if (this.pitchHoldCounter > 2) {
            if (this.detectedFrequency < this.getLowerToleranceBoundaryFrequency(this.targetPitchIndex)) {
                if (this.vibrate) {
                    this.vibrator.vibrate(VIBRATE_PATTERN_UP, -1);
                }
            } else if (this.detectedFrequency > this.getUpperToleranceBoundaryFrequency(this.targetPitchIndex)) {
                if (this.vibrate) {
                    this.vibrator.vibrate(VIBRATE_PATTERN_DOWN, -1);
                }
            } else {
                if (this.vibrate) {
                    this.vibrator.vibrate(VIBRATE_PATTERN_TUNED, -1);
                }
                if (this.playNoteOn) {
                    this.callbackInterface.playNoteWhenTuned(this.targetFrequency);
                }
            }
            this.pitchHoldCounter = 0;
        }
        boolean success = this.callbackInterface.process(this);
        this.lastDetectedFrequency = this.detectedFrequency;
        if (this.lastTargetFrequency <= 0.0f) {
            this.targetFrequency = 0.0f;
        }
        this.lastTargetFrequency = this.targetFrequency;
        return success;
    }

    private void calcHarmonicProductSpectrum(float[] mag, float[] hps, int order) {
        if (mag.length != hps.length) {
            Log.e((String)LOGTAG, (String)"calcHarmonicProductSpectrum: mag[] and hps[] have to be of the same length!");
            throw new IllegalArgumentException("mag[] and hps[] have to be of the same length");
        }
        System.arraycopy(mag, 0, hps, 0, mag.length);
        for (int harmonic = 2; harmonic <= order; ++harmonic) {
            for (int i = 0; i < hps.length / harmonic; ++i) {
                int n = i;
                hps[n] = hps[n] + mag[i * harmonic];
            }
        }
    }

    public void setLowCutOffFrequency(int freq) {
        this.lowCutOffFrequency = freq;
        Log.d((String)LOGTAG, (String)("Low cut-off frequency set to " + freq + " Hz"));
    }

    public int frequencyToPitchIndex(float frequency) {
        float A1 = this.CONCERT_PITCH / 8.0f;
        return Math.round((float)(12.0 * Math.log(frequency / A1) / Math.log(2.0)));
    }

    public void setConcertPitch(float newConcertPitch) {
        if (newConcertPitch > 0.0f) {
            this.CONCERT_PITCH = newConcertPitch;
            Log.i((String)LOGTAG, (String)("Concert pitch changed to " + newConcertPitch + " Hz"));
        }
    }

    public float pitchIndexToFrequency(int index) {
        float A1 = this.CONCERT_PITCH / 8.0f;
        return (float)((double)A1 * Math.pow(2.0, (float)index / 12.0f));
    }

    public void setPlayNote(boolean playNoteOn) {
        this.playNoteOn = playNoteOn;
    }

    public String pitchLetterFromIndex(int index) {
        String letters;
        int octaveNumber = (index + 9) / 12 + 1;
        switch (index % 12) {
            case 0: {
                letters = "A" + octaveNumber;
                break;
            }
            case 1: {
                letters = "A" + octaveNumber + "#";
                break;
            }
            case 2: {
                if (Locale.getDefault().getLanguage().equals("en")) {
                    letters = "B" + octaveNumber;
                    break;
                }
                letters = "H" + octaveNumber;
                break;
            }
            case 3: {
                letters = "C" + octaveNumber;
                break;
            }
            case 4: {
                letters = "C" + octaveNumber + "#";
                break;
            }
            case 5: {
                letters = "D" + octaveNumber;
                break;
            }
            case 6: {
                letters = "D" + octaveNumber + "#";
                break;
            }
            case 7: {
                letters = "E" + octaveNumber;
                break;
            }
            case 8: {
                letters = "F" + octaveNumber;
                break;
            }
            case 9: {
                letters = "F" + octaveNumber + "#";
                break;
            }
            case 10: {
                letters = "G" + octaveNumber;
                break;
            }
            case 11: {
                letters = "G" + octaveNumber + "#";
                break;
            }
            default: {
                letters = "err";
            }
        }
        return letters;
    }

    public float getLowerToleranceBoundaryFrequency(int pitchIndex) {
        float frequency = this.pitchIndexToFrequency(pitchIndex);
        float nextLowerFrequency = this.pitchIndexToFrequency(pitchIndex - 1);
        return frequency - 0.05f * (frequency - nextLowerFrequency);
    }

    public float getUpperToleranceBoundaryFrequency(int pitchIndex) {
        float frequency = this.pitchIndexToFrequency(pitchIndex);
        float nextUpperFrequency = this.pitchIndexToFrequency(pitchIndex + 1);
        return frequency + 0.05f * (nextUpperFrequency - frequency);
    }

    public boolean isTuned() {
        return this.detectedFrequency > this.getLowerToleranceBoundaryFrequency(this.targetPitchIndex) && this.detectedFrequency < this.getUpperToleranceBoundaryFrequency(this.targetPitchIndex);
    }

    public float getStrongestFrequency() {
        return this.strongestFrequency;
    }

    public float[] getMag() {
        return this.mag;
    }

    public float[] getHPS() {
        return this.hps;
    }

    public float getUpdateRate() {
        return this.updateRate;
    }

    public long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public float getHzPerSample() {
        return this.hzPerSample;
    }

    public float getDetectedFrequency() {
        return this.detectedFrequency;
    }

    public float getTargetFrequency() {
        return this.targetFrequency;
    }

    public int getTargetPitchIndex() {
        return this.targetPitchIndex;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isVibrate() {
        return this.vibrate;
    }

    public void setVibrate(boolean vibrate) {
        this.vibrate = vibrate;
    }

    public float getLastDetectedFrequency() {
        return this.lastDetectedFrequency;
    }

    public float getLastTargetFrequency() {
        return this.lastTargetFrequency;
    }

    public static interface GuitarTunerCallbackInterface {
        public boolean process(GuitarTuner var1);

        public void playNoteWhenTuned(float var1);
    }
}

