/*
 * Decompiled with CFR 0.152.
 */
package com.mantz_it.guitartunerlibrary;

public class FFT {
    int n;
    int m;
    float[] cos;
    float[] sin;
    float[] window;

    public FFT(int n) {
        this.n = n;
        this.m = (int)(Math.log(n) / Math.log(2.0));
        if (n != 1 << this.m) {
            throw new RuntimeException("FFT length must be power of 2");
        }
        this.cos = new float[n / 2];
        this.sin = new float[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            this.cos[i] = (float)Math.cos(Math.PI * -2 * (double)i / (double)n);
            this.sin[i] = (float)Math.sin(Math.PI * -2 * (double)i / (double)n);
        }
        this.makeWindow();
    }

    protected void makeWindow() {
        this.window = new float[this.n];
        for (int i = 0; i < this.window.length; ++i) {
            this.window[i] = (float)(0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)i / (double)(this.n - 1)) + 0.08 * Math.cos(Math.PI * 4 * (double)i / (double)(this.n - 1)));
        }
    }

    public float[] getWindow() {
        return this.window;
    }

    public void applyWindow(float[] re, float[] im) {
        for (int i = 0; i < this.window.length; ++i) {
            re[i] = this.window[i] * re[i];
            im[i] = this.window[i] * im[i];
        }
    }

    public void fft(float[] x, float[] y) {
        float t1;
        int n1;
        int i;
        int j = 0;
        int n2 = this.n / 2;
        for (i = 1; i < this.n - 1; ++i) {
            for (n1 = n2; j >= n1; j -= n1, n1 /= 2) {
            }
            if (i >= (j += n1)) continue;
            t1 = x[i];
            x[i] = x[j];
            x[j] = t1;
            t1 = y[i];
            y[i] = y[j];
            y[j] = t1;
        }
        n1 = 0;
        n2 = 1;
        for (i = 0; i < this.m; ++i) {
            n1 = n2;
            n2 += n2;
            int a = 0;
            for (j = 0; j < n1; ++j) {
                float c = this.cos[a];
                float s = this.sin[a];
                a += 1 << this.m - i - 1;
                for (int k = j; k < this.n; k += n2) {
                    t1 = c * x[k + n1] - s * y[k + n1];
                    float t2 = s * x[k + n1] + c * y[k + n1];
                    x[k + n1] = x[k] - t1;
                    y[k + n1] = y[k] - t2;
                    x[k] = x[k] + t1;
                    y[k] = y[k] + t2;
                }
            }
        }
    }
}

