/*
 * Decompiled with CFR 0.152.
 */
package com.mantz_it.guitartunerlibrary;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Shader;
import com.mantz_it.guitartunerlibrary.GuitarTuner;
import com.mantz_it.guitartunerlibrary.TunerSkin;

public class DefaultTunerSkin
extends TunerSkin {
    protected Paint gradientPaint = new Paint();
    protected Paint needleFillPaint;
    protected float maxAngle = 0.8f;
    protected float sideLettersPosition = 0.7f;

    public DefaultTunerSkin() {
        this.gradientPaint.setAntiAlias(true);
        this.needleFillPaint = new Paint();
        this.needleFillPaint.setAntiAlias(true);
        this.foregroundPaint.setStrokeWidth(3.0f);
        this.highlightPaint.setStrokeWidth(3.0f);
        this.animationEnabled = true;
    }

    @Override
    public void updateWidthAndHeight(int width, int height) {
        super.updateWidthAndHeight(width, height);
        float newTextSize = (float)height * 0.16f;
        this.foregroundPaint.setTextSize(newTextSize);
        this.invalidPaint.setTextSize(newTextSize);
        this.highlightPaint.setTextSize(newTextSize);
        this.highlightPaint.setColor(Color.parseColor((String)"#28C902"));
        this.gradientPaint.setTextSize(newTextSize);
        this.foregroundPaint.setColor(Color.parseColor((String)"#D32F2F"));
        this.gradientPaint.setShader((Shader)new LinearGradient(0.0f, 0.0f, (float)(width / 2), 0.0f, -12303292, -3355444, Shader.TileMode.MIRROR));
        this.gradientPaint.setStrokeWidth(5.0f);
    }

    @Override
    public void setRound(boolean round) {
        super.setRound(round);
    }

    @Override
    public void draw(Canvas c, GuitarTuner tuner) {
        this.draw(c, tuner, 0, 1);
    }

    @Override
    public void draw(Canvas c, GuitarTuner tuner, int frameNumber, int framesPerCycle) {
        c.drawRect(0.0f, 0.0f, (float)this.width, (float)this.height, this.backgroundPaint);
        this.drawScale(c);
        if (tuner.isValid() && tuner.getTargetFrequency() > 0.0f) {
            float angle;
            float targetFrequency = tuner.getTargetFrequency();
            int targetPitchIndex = tuner.getTargetPitchIndex();
            String centerLetter = tuner.pitchLetterFromIndex(targetPitchIndex);
            Paint letterPaint = tuner.isTuned() ? this.highlightPaint : this.foregroundPaint;
            this.drawPitchLetter(c, centerLetter, 0.0f, 0.17f, true, letterPaint);
            double TUNED_THRESHOLD_CENTS = 2.5;
            double detectedFrequency = tuner.getDetectedFrequency();
            double diffInCents = 1200.0 * Math.log(detectedFrequency / (double)targetFrequency) / Math.log(2.0);
            if (Math.abs(diffInCents) < 2.5) {
                angle = 0.0f;
            } else {
                double clampedDiff = Math.max(-50.0, Math.min(50.0, diffInCents));
                angle = (float)(clampedDiff / 50.0) * this.maxAngle;
            }
            this.drawNeedle(c, angle, tuner.isTuned() ? this.highlightPaint : this.foregroundPaint);
        } else {
            this.drawPitchLetter(c, "---", 0.0f, 0.17f, true, this.invalidPaint);
        }
    }

    protected void drawPitchLetter(Canvas c, String letter, float xPosition, float yPosition, boolean round, Paint paint) {
        Rect bounds = new Rect();
        paint.getTextBounds(letter, 0, letter.length(), bounds);
        float x = (float)(this.width - bounds.width()) / 2.0f;
        float y = (float)this.height * yPosition;
        c.drawText(letter, 0, letter.length(), x, y, paint);
    }

    protected void drawScale(Canvas c) {
        float pivotX = (float)this.width / 2.0f;
        float pivotY = (float)this.height * 0.88f;
        float scaleRadius = (float)this.height * 0.6f;
        float centerAngle = 0.0f;
        float startX = pivotX + (float)Math.sin(centerAngle) * (scaleRadius - (float)this.height * 0.05f);
        float startY = pivotY - (float)Math.cos(centerAngle) * (scaleRadius - (float)this.height * 0.05f);
        float endX = pivotX + (float)Math.sin(centerAngle) * (scaleRadius + (float)this.height * 0.05f);
        float endY = pivotY - (float)Math.cos(centerAngle) * (scaleRadius + (float)this.height * 0.05f);
        c.drawLine(startX, startY, endX, endY, this.gradientPaint);
        int numSideDashes = 5;
        for (int i = 1; i <= numSideDashes; ++i) {
            float dashLength = i == numSideDashes ? (float)this.height * 0.05f : (float)this.height * 0.025f;
            float positiveAngle = this.maxAngle * (float)i / (float)numSideDashes;
            float negativeAngle = -positiveAngle;
            startX = pivotX + (float)Math.sin(positiveAngle) * (scaleRadius - dashLength);
            startY = pivotY - (float)Math.cos(positiveAngle) * (scaleRadius - dashLength);
            endX = pivotX + (float)Math.sin(positiveAngle) * (scaleRadius + dashLength);
            endY = pivotY - (float)Math.cos(positiveAngle) * (scaleRadius + dashLength);
            c.drawLine(startX, startY, endX, endY, this.gradientPaint);
            startX = pivotX + (float)Math.sin(negativeAngle) * (scaleRadius - dashLength);
            startY = pivotY - (float)Math.cos(negativeAngle) * (scaleRadius - dashLength);
            endX = pivotX + (float)Math.sin(negativeAngle) * (scaleRadius + dashLength);
            endY = pivotY - (float)Math.cos(negativeAngle) * (scaleRadius + dashLength);
            c.drawLine(startX, startY, endX, endY, this.gradientPaint);
        }
    }

    protected void drawNeedle(Canvas c, float angle, Paint paint) {
        float needleLength = (float)this.height * 0.55f;
        float needleBaseWidth = (float)this.width * 0.05f;
        float pivotX = (float)this.width / 2.0f;
        float pivotY = (float)this.height * 0.88f;
        float tipX = pivotX + (float)Math.sin(angle) * needleLength;
        float tipY = pivotY - (float)Math.cos(angle) * needleLength;
        float baseCornerX1 = pivotX - (float)Math.cos(angle) * needleBaseWidth / 2.0f;
        float baseCornerY1 = pivotY - (float)Math.sin(angle) * needleBaseWidth / 2.0f;
        float baseCornerX2 = pivotX + (float)Math.cos(angle) * needleBaseWidth / 2.0f;
        float baseCornerY2 = pivotY + (float)Math.sin(angle) * needleBaseWidth / 2.0f;
        Path needlePath = new Path();
        needlePath.moveTo(tipX, tipY);
        needlePath.lineTo(baseCornerX1, baseCornerY1);
        needlePath.lineTo(baseCornerX2, baseCornerY2);
        needlePath.close();
        this.needleFillPaint.setColor(paint.getColor());
        this.needleFillPaint.setAlpha(100);
        c.drawPath(needlePath, this.needleFillPaint);
        c.drawPath(needlePath, paint);
        c.drawCircle(pivotX, pivotY, needleBaseWidth / 1.5f, paint);
    }
}

