/*
 * Decompiled with CFR 0.152.
 */
package com.mantz_it.guitartunerlibrary;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import com.mantz_it.guitartunerlibrary.GuitarTuner;
import com.mantz_it.guitartunerlibrary.TunerSkin;
import java.text.DecimalFormat;

public class DebugTunerSkin
extends TunerSkin {
    protected Paint fftPaint;

    @Override
    public void updateWidthAndHeight(int width, int height) {
        super.updateWidthAndHeight(width, height);
        this.fftPaint = new Paint();
        this.fftPaint.setColor(Color.parseColor((String)"#D32F2F"));
        this.highlightPaint.setColor(Color.parseColor((String)"#28C902"));
        this.foregroundPaint.setTextSize((float)height * 0.1f);
        this.invalidPaint.setTextSize((float)height * 0.1f);
    }

    @Override
    public void draw(Canvas c, GuitarTuner tuner) {
        int startFrequency = 50;
        int endFrequency = 500;
        int startIndex = (int)((float)startFrequency / tuner.getHzPerSample());
        int endIndex = (int)((float)endFrequency / tuner.getHzPerSample());
        float samplesPerPx = (float)(endIndex - startIndex) / (float)this.width;
        float hzPerPx = tuner.getHzPerSample() * samplesPerPx;
        c.drawRect(0.0f, 0.0f, (float)this.width, (float)this.height, this.backgroundPaint);
        this.drawSpectrum(c, this.fftPaint, tuner.getMag(), startIndex, endIndex, -9.0f, -2.0f, tuner.getHzPerSample());
        this.drawSpectrum(c, this.highlightPaint, tuner.getHPS(), startIndex, endIndex, -35.0f, -15.0f, tuner.getHzPerSample());
        if (tuner.isValid() && tuner.getDetectedFrequency() > 0.0f) {
            float detectedFrequency = tuner.getDetectedFrequency();
            int pitchIndex = tuner.getTargetPitchIndex();
            Paint paint = this.foregroundPaint;
            int frequencyPosition = (int)((detectedFrequency - (float)startFrequency) / hzPerPx);
            c.drawLine((float)frequencyPosition, 0.0f, (float)frequencyPosition, (float)this.height, paint);
            float yPos = (float)this.height * 0.3f;
            String text = new DecimalFormat("###.# Hz").format(detectedFrequency);
            Rect bounds = new Rect();
            paint.getTextBounds(text, 0, text.length(), bounds);
            int labelPosition = frequencyPosition <= this.width / 2 ? frequencyPosition + 5 : frequencyPosition - bounds.width() - 5;
            c.drawText(text, 0, text.length(), (float)labelPosition, yPos, paint);
            text = tuner.pitchLetterFromIndex(pitchIndex) + new DecimalFormat(" (###.# Hz)").format(tuner.pitchIndexToFrequency(pitchIndex));
            paint.getTextBounds(text, 0, text.length(), bounds);
            labelPosition = frequencyPosition <= this.width / 2 ? frequencyPosition + 5 : frequencyPosition - bounds.width() - 5;
            c.drawText(text, 0, text.length(), (float)labelPosition, yPos += (float)bounds.height() * 1.1f, paint);
        }
    }

    private void drawSpectrum(Canvas c, Paint paint, float[] values, int start, int end, float minDB, float maxDB, float hzPerSample) {
        float previousY = this.height;
        float samplesPerPx = (float)(end - start) / (float)this.width;
        float dbDiff = maxDB - minDB;
        float dbWidth = (float)this.height / dbDiff;
        for (int i = 1; i < this.width; ++i) {
            float avg = 0.0f;
            int counter = 0;
            int j = (int)((float)i * samplesPerPx);
            while ((float)j < (float)(i + 1) * samplesPerPx) {
                avg += values[j + start];
                ++counter;
                ++j;
            }
            float currentY = (float)this.height - ((avg /= (float)counter) - minDB) * dbWidth;
            if (currentY < 0.0f) {
                currentY = 0.0f;
            }
            if (currentY > (float)this.height) {
                currentY = this.height;
            }
            c.drawLine((float)(i - 1), previousY, (float)i, currentY, paint);
            previousY = currentY;
            if (i + 1 != this.width) continue;
            c.drawLine((float)i, previousY, (float)(i + 1), (float)this.height, paint);
        }
    }
}

