/*
 * Decompiled with CFR 0.152.
 */
package com.mantz_it.guitartunerlibrary;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.util.Log;
import com.mantz_it.guitartunerlibrary.FFT;
import com.mantz_it.guitartunerlibrary.GuitarTuner;

public class AudioProcessingEngine
extends Thread {
    private static final String LOGTAG = "AudioProcessingEngine";
    private static int RECORDER_SAMPLERATE = 48000;
    private static final int RECORDER_CHANNELS = 16;
    private static final int RECORDER_AUDIO_ENCODING = 2;
    private static final int RECORDER_ELEMENT_SIZE = 2;
    private static final int BUFFER_SIZE = 24576;
    private static final int FFT_SIZE = 262144;
    private float[] lookupTable;
    private short[] audioBuffer;
    private float[] realSamples;
    private float[] imagSamples;
    private float[] mag;
    private AudioRecord audioRecord;
    private FFT fftInstance;
    private GuitarTuner guitarTuner;
    private Context context;
    private boolean stopRequested = true;
    private int failCounter = 0;

    public AudioProcessingEngine(GuitarTuner guitarTuner, Context context) {
        this.guitarTuner = guitarTuner;
        this.context = context;
        this.createLookupTable();
        this.fftInstance = new FFT(262144);
    }

    private void createLookupTable() {
        this.lookupTable = new float[65536];
        for (int i = 0; i < this.lookupTable.length; ++i) {
            this.lookupTable[i] = ((float)i - 32768.0f) / 32768.0f;
        }
    }

    public void short2float(short[] in, float[] out) {
        for (int i = 0; i < Math.min(in.length, out.length); ++i) {
            out[i] = this.lookupTable[in[i] + 32768];
        }
    }

    public void stopProcessing() {
        this.stopRequested = true;
    }

    @Override
    public void run() {
        this.stopRequested = false;
        Log.i((String)LOGTAG, (String)("run: AudioProcessingEngine '" + this.getName() + "' started."));
        AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
        String nativeSampleRateStr = audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        int nativeSampleRate = 0;
        if (nativeSampleRateStr != null) {
            nativeSampleRate = Integer.parseInt(nativeSampleRateStr);
        }
        if (nativeSampleRate == 0) {
            nativeSampleRate = 48000;
        }
        RECORDER_SAMPLERATE = nativeSampleRate;
        Log.d((String)LOGTAG, (String)("Device native sample rate is: " + RECORDER_SAMPLERATE + " Hz. Using this for recording."));
        int minBufferSize = AudioRecord.getMinBufferSize((int)RECORDER_SAMPLERATE, (int)16, (int)2);
        Log.d((String)LOGTAG, (String)("constructor: min. buffer size is " + minBufferSize));
        int audioBufferSize = Math.max(minBufferSize, 49152) * 2;
        this.audioRecord = new AudioRecord(1, RECORDER_SAMPLERATE, 16, 2, audioBufferSize);
        this.audioBuffer = new short[24576];
        this.realSamples = new float[262144];
        this.imagSamples = new float[262144];
        this.mag = new float[131072];
        if (this.audioRecord.getState() != 1) {
            Log.e((String)LOGTAG, (String)"run: audioRecord is null or not initialized! Abort!");
            this.stopRequested = true;
            return;
        }
        this.audioRecord.startRecording();
        while (!this.stopRequested) {
            int i;
            if (this.audioRecord.read(this.audioBuffer, 0, this.audioBuffer.length) != this.audioBuffer.length) {
                Log.e((String)LOGTAG, (String)"run: Error while reading from AudioRecord. stop.");
                this.stopRequested = true;
                break;
            }
            Log.d((String)LOGTAG, (String)("run: audioBuffer: " + this.audioBuffer[0] + ", " + this.audioBuffer[1] + ", " + this.audioBuffer[2] + ", ..., " + this.audioBuffer[500]));
            for (i = 0; i < this.realSamples.length; ++i) {
                this.realSamples[i] = 0.0f;
                this.imagSamples[i] = 0.0f;
            }
            this.short2float(this.audioBuffer, this.realSamples);
            this.fftInstance.applyWindow(this.realSamples, this.imagSamples);
            this.fftInstance.fft(this.realSamples, this.imagSamples);
            for (i = 0; i < this.realSamples.length / 2; ++i) {
                float realPower = this.realSamples[i] / 262144.0f;
                realPower *= realPower;
                float imagPower = this.imagSamples[i] / 262144.0f;
                imagPower *= imagPower;
                this.mag[i] = (float)Math.log10(Math.sqrt(realPower + imagPower));
            }
            this.failCounter = !this.guitarTuner.processFFTSamples(this.mag, RECORDER_SAMPLERATE, (float)RECORDER_SAMPLERATE / 24576.0f) ? ++this.failCounter : 0;
            if (this.failCounter <= 10) continue;
            Log.w((String)LOGTAG, (String)"run: Calling processFFTSamples() failed 10 times in a row. stop.");
            this.stopRequested = true;
        }
        this.audioRecord.stop();
        this.audioRecord.release();
        Log.i((String)LOGTAG, (String)("run: AudioProcessingEngine '" + this.getName() + "' stopped"));
        this.stopRequested = true;
    }
}

